<?php
/************************************************************************/
/* ATutor																*/
/************************************************************************/
/* Copyright (c) 2002-2010                                              */
/* Inclusive Design Institute                                           */
/* http://atutor.ca                                                     */
/* This program is free software. You can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License          */
/* as published by the Free Software Foundation.                        */
/************************************************************************/
// $Id$

define('AT_INCLUDE_PATH', '../../../include/');
require (AT_INCLUDE_PATH.'vitals.inc.php');
authenticate(AT_PRIV_ENROLLMENT);

$completed = 0;

/*EXPORT LIST OF STUDENTS*/
if(isset($_POST['export'])) {
	//if not list was selected
	if (!$_POST['enrolled'] && !$_POST['pending_enrollment'] && !$_POST['alumni']) {
		$msg->addError('NO_STUDENT_SELECTED');
	}
	//retrieve info from database based on selection (make sure that instructor is not exported!)
	else {
		if ($_POST['enrolled'] && $_POST['pending_enrollment'] && $_POST['alumni']) {
			$condition = "";
		} else if ($_POST['enrolled'] && $_POST['pending_enrollment']) {
			$condition = "AND approved <> 'a'";
		} else if ($_POST['enrolled'] && $_POST['alumni']) {
			$condition = "AND approved <> 'n'";
		} else if ($_POST['pending_enrollment'] && $_POST['alumni']) {
			$condition = "AND approved <> 'y'";
		} else if ($_POST['pending_enrollment']) {
			$condition = "AND approved = 'n'";				
		} else if ($_POST['enrolled']) {
			$condition = "AND approved = 'y'";
		} else if ($_POST['alumni']) {
			$condition = "AND approved = 'a'";
		} 

		$sql = "SELECT m.first_name, m.last_name, m.email 
				FROM %scourse_enrollment cm JOIN %smembers m ON cm.member_id = m.member_id JOIN %scourses c ON (cm.course_id = c.course_id AND cm.member_id <> c.member_id)	WHERE cm.course_id = %d " . $condition . "ORDER BY m.last_name";
		$rows_enrollment =  queryDB($sql,array(TABLE_PREFIX, TABLE_PREFIX, TABLE_PREFIX, $_SESSION['course_id']));
		foreach($rows_enrollment as $row){	
			$this_row .= quote_csv($row['first_name']).",";
			$this_row .= quote_csv($row['last_name']).",";
			$this_row .= quote_csv($row['email'])."\n";
		}

		if ($this_row) {
			header('Content-Type: text/csv');
			header('Content-transfer-encoding: binary');
			header('Content-Disposition: attachment; filename="course_list_'.$_SESSION['course_id'].'.csv"');
			header('Expires: 0');
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Pragma: public');

			echo $this_row;
		} else {
			// nothing to send. empty file
			$msg->addError('ENROLLMENT_NONE_FOUND');
			header('Location: export_course_list.php');
		}
		exit;
	}
}
if(isset($_POST['cancel'])) {
	$msg->addFeedback('CANCELLED');
	header('Location: index.php');
	exit;
}

if(isset($_POST['done'])) {
	$msg->addFeedback('ACTION_COMPLETED_SUCCESSFULLY');
	header('Location: index.php');
	exit;
}
require(AT_INCLUDE_PATH.'header.inc.php');



/**
* Creates csv file to be exported
* @access  private
* @param   string $line		The line ot be converted to csv
* @return  string			The line after conversion to csv
* @author  Shozub Qureshi
*/
function quote_csv($line) {
	$line = str_replace('"', '""', $line);

	$line = str_replace("\n", '\n', $line);
	$line = str_replace("\r", '\r', $line);
	$line = str_replace("\x00", '\0', $line);

	return '"'.$line.'"';
}
$savant->display('instructor/enrolment/export_course_list.tmpl.php');
require(AT_INCLUDE_PATH.'footer.inc.php'); 
?>